#include <bits/stdc++.h>
using namespace std;

const int MX = 20005;
const int INF = 1e9;

struct P { int id; double x, y; } p[MX];
struct PO { double x, y; } o[MX];
struct E { 
    int u, v; double w; 
    bool operator<(const E& o) const { return w < o.w; } 
};

int n, pr[MX], bi[MX];
double eps, bv[MX];
vector<int> Y;
vector<E> e, me;

int f(int i) { return pr[i] == i ? i : pr[i] = f(pr[i]); }
void un(int i, int j) { pr[f(i)] = f(j); }

void u(int i, double v, int id) {
    for (; i > 0; i -= i & -i) 
        if (v < bv[i]) bv[i] = v, bi[i] = id;
}

int q(int i) {
    int r = -1; double m = INF;
    for (; i <= n; i += i & -i) 
        if (bv[i] < m) m = bv[i], r = bi[i];
    return r;
}

double d(int i, int j) { 
    return abs(o[i].x - o[j].x) + abs(o[i].y - o[j].y); 
}

void sl() {
    sort(p, p + n, [](P a, P b) { return a.x < b.x || (a.x == b.x && a.y < b.y); });
    Y.clear();
    for (int i = 0; i < n; ++i) Y.push_back(p[i].y - p[i].x);
    sort(Y.begin(), Y.end());
    Y.erase(unique(Y.begin(), Y.end()), Y.end());
    
    for (int i = 1; i <= n; ++i) bv[i] = INF, bi[i] = -1;

    for (int i = n - 1; i >= 0; --i) {
        int pos = lower_bound(Y.begin(), Y.end(), p[i].y - p[i].x) - Y.begin() + 1;
        int j = q(pos);
        if (j != -1) e.push_back({p[i].id, j, d(p[i].id - 1, j - 1)}); 
        u(pos, p[i].x + p[i].y, p[i].id);
    }
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0);
    if (!(cin >> n >> eps)) return 0;
    
    for (int i = 0; i < n; ++i) {
        cin >> p[i].x >> p[i].y;
        p[i].id = i + 1;
        o[i].x = p[i].x; o[i].y = p[i].y;
    }

    for (int k = 0; k < 4; ++k) {
        sl();
        for (int i = 0; i < n; ++i) {
            double nx = p[i].y, ny = -p[i].x;
            p[i].x = nx; p[i].y = ny;
        }
    }

    sort(e.begin(), e.end());
    for (int i = 1; i <= n; ++i) pr[i] = i;
    for (auto& x : e) {
        if (f(x.u) != f(x.v)) {
            un(x.u, x.v);
            me.push_back(x);
        }
    }

    double S = eps / 4.0; 
    map<pair<int, int>, int> mp; 
    vector<int> Q, nm(n + 1);

    for (int i = 0; i < n; ++i) {
        int r = floor(o[i].x / S);
        int c = floor(o[i].y / S);
        if (mp.find({r, c}) == mp.end()) {
            mp[{r, c}] = i + 1;
            Q.push_back(i + 1);
        }
        nm[i + 1] = mp[{r, c}];
    }

    vector<E> fe;
    for (auto& x : me) {
        int u = nm[x.u], v = nm[x.v];
        if (u != v) fe.push_back({u, v, 0});
    }

    cout << Q.size() << "\n";
    for (int i = 0; i < Q.size(); ++i) cout << Q[i] << (i == Q.size() - 1 ? "" : " ");
    cout << "\n";

    for (int i : Q) pr[i] = i;
    for (auto& x : fe) {
        if (f(x.u) != f(x.v)) {
            un(x.u, x.v);
            cout << x.u << " " << x.v << "\n";
        }
    }
    return 0;
}